
-- DBU 2999-08-04 15:00:04 "DBU automatisch schließen" schließt alle alten DBUpdates, entsprechend dieses Datums.
-- Datum laut letzter Bearbeitung im Repository \PSQL\,
-- zu welchem alle davor erstellten DBUpdates (hoffentlich) bereits im Erstellungsscript eingecheckt wurden.
-- Daher zeitliche Toleranz erforderlich.
-- Format nach ISO 8601, also YYYY-MM-DD
SELECT TSystem.Settings__Set('DBU_date_for_auto_done', '2025-11-01');
SELECT TSystem.Settings__Set('ProdatVersion', '24.25.07.99') -- 24.25.08.00

-- siehe Trigger dbupdates__b_i: automatisches Schließen der DB-Updates (upd_donedat und upd_txt setzen)


/*
-- ACHTUNG, wenn DBUpdates schon einmal gestartet wurden und nachträglich das Datum nochmal geändert/neu gesetzt wird (z.B. durch Fehler bei Datenbankeinrichtung durch zu altes Datum),
-- dann müssen manuell die "alten" DBUpdates geschlossen werden, da der entsprechende UpdatesSchließen-Code bereits ausgeführt wurde.

-- prüfen ob DBUpdates im Prodat bereits einmal gestartet wurden
SELECT upd_donedat IS NOT NULL FROM dbupdates WHERE upd_id = '2999-08-04 15:03:29';

-- wenn JA, dann jetzt die alten DBUpdates schließen
SELECT TSystem.triggers__all__disable();

UPDATE dbupdates SET
  upd_donedat = currenttime(),
  upd_txt = E'[DBU-AUTO-DONE]\n' || COALESCE(upd_txt, '')
WHERE upd_id::DATE <= COALESCE(nullif(TSystem.Settings__Get('DBU_date_for_auto_done'), ''), '1900-01-01')::DATE
  AND upd_donedat IS NULL;

SELECT TSystem.triggers__all__enable();
*/
